#!/bin/bash

LIST_UPDATES_FOR="all"

get-base-updates() {
  pacman -Qu | wc -l
}

get-aur-updates() {
  base=$(get-base-updates)
  all=$(yay -Qu | wc -l)
  echo $(( ${all} - ${base} ))
}

usage() {
  exitcode=0

  if [ $1 != "" ]; then
    exitcode=$1
  fi

  echo "USAGE: update-checker.sh [ flag ]"
  echo "DESCRIPTION:"
  echo "Returns the number of packages available for update."
  echo "If no flag is provided, both base and aur package update"
  echo "values will be returned."
  echo ""
  echo "FLAGS"
  echo "-b    pacman repository packages only"
  echo "-a    aur packages only"
  echo "-h    print this message"

  exit $exitcode
}

PARSED_ARGS=$(getopt -o bah -- "$@")
VALID_ARGS=$?
if [ "$VALID_ARGS" != 0 ]; then
  usage 1
fi

eval set -- "$PARSED_ARGS"
PRINT_USAGE=0

while : 
do
  case $1 in
    -b)
      if [ "$LIST_UPDATES_FOR" != "all" ]; then
        echo "ERROR: invalid flag combination used, must be either -a OR -b, not both"
        usage 1
      fi

      LIST_UPDATES_FOR="base"
      shift
      ;;
    -a)
      if [ "$LIST_UPDATES_FOR" != "all" ]; then
        echo "ERROR: invalid flag combination used, must be either -a OR -b, not both"
        echo ""
        usage 1
      fi

      LIST_UPDATES_FOR="aur"
      shift
      ;;
    -h)
      usage
      ;;
    --) 
      shift
      break
      ;;
    *)
      echo "invalid option $1"
      usage 1
      ;;  
  esac
done

case $LIST_UPDATES_FOR in
  aur)
    get-aur-updates
    ;;
  base)
    get-base-updates
    ;;
  all)
    base=$(get-base-updates)
    aur=$(get-aur-updates)
    echo "base: $base"
    echo "aur:  $aur"
esac
